﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace KursBeispiele
{
    public partial class Bitflag : Form
    {
        public Bitflag()
        {
            InitializeComponent();

            //Setzen den FormBorderStyle neu - hier Fixed (Größe kann nicht geändert werden)
            //und Single (einzelner Rahmen)
            FormBorderStyle = FormBorderStyle.FixedSingle;

            //Soll das Icon nicht anzeigen
            ShowIcon = false;

            //Soll über allen Formularen liegen - auch außerhalb der Applikation
            TopMost = true;
        }

        [Flags]
        enum FBeispiel
        {
            //Hexadezimal (0x) lassen sich die Werte sehr schön eingeben - 0, 1, 2, 4, 8, 16, ...
            One = 0x0,
            Two = 0x1,
            Three = 0x2,
            //Eigenes = 3,
            Four = 0x4,
            Five = 0x8,
            Six = 0x10,
            Seven = 0x20,
            Eight = 0x40,
            Nine = 0x80,
            Ten = 0x100,
        }

        private void Bitflag_Load(object sender, EventArgs e)
        {
            //Fügen Oberelement dazu und arbeiten mit diesem Knoten
            TreeNode topNode = treeView1.Nodes.Add("Alle Daten");
            TreeNode middleNode = treeView1.Nodes.Add("Nur Werte");
            TreeNode bottomNode = treeView1.Nodes.Add("Nur Namen");

            //Werte und Namen holen
            string[] names = Enum.GetNames(typeof(FBeispiel));
            Array values = Enum.GetValues(typeof(FBeispiel));

            //Die einzelnen Knoten auffüllen
            for (int i = 0; i < values.Length; i++)
            {
                topNode.Nodes.Add(((int)values.GetValue(i)).ToString() + ": " + names[i]);
                middleNode.Nodes.Add(((int)values.GetValue(i)).ToString());
                bottomNode.Nodes.Add(names[i]);

                //die checkedListBox auffüllen
                checkedListBox1.Items.Add(names[i]);
            }

            //Alles anzeigen lassen
            treeView1.ExpandAll();
        }

        //Tritt ein wenn sich ein Element der Liste ändert - wird aber vor der Änderung geworfen !
        private void checkedListBox1_ItemCheck(object sender, ItemCheckEventArgs e)
        {
            FBeispiel bsp = FBeispiel.One;
            TypeConverter tc = TypeDescriptor.GetConverter(typeof(FBeispiel));

            //Neuen Wert manuell setzen - da dieses Event vor dem Ändern abläuft
            //Zuerst Event-Handler entfernen - sonst wird wieder dieser EventHandler ausgeführt
            checkedListBox1.ItemCheck -= new ItemCheckEventHandler(checkedListBox1_ItemCheck);
            checkedListBox1.SetItemCheckState(e.Index, e.NewValue);
            //Danach wieder den EventHandler hinzufügen - ansonsten wird das Event nicht mehr ausgeführt
            checkedListBox1.ItemCheck += new ItemCheckEventHandler(checkedListBox1_ItemCheck);

            //Werte hinzufügen
            for (int i = 0; i < checkedListBox1.CheckedItems.Count; i++)
                bsp |= (FBeispiel)tc.ConvertFromString(checkedListBox1.CheckedItems[i].ToString());

            //Repräsentationen ausgeben
            textBox1.Text = ((int)bsp).ToString();
            textBox2.Text = bsp.ToString();
        }
    }
}
